{********************************************************************}
{ TCOLUMNLISTBOX DEMO                                                }
{                                                                    }
{ written by TMS Software                                            }
{            copyright  1998-2008                                   }
{            Email : info@tmssoftware.com                            }
{            Website : http://www.tmssoftware.com                    }
{********************************************************************}

unit Ucldragdrop;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, collistb, ImgList, ShellApi;

type
  TForm1 = class(TForm)
    ColumnListBox1: TColumnListBox;
    ImageList1: TImageList;
    ListBox1: TListBox;
    Label1: TLabel;
    procedure ColumnListBox1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ColumnListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ColumnListBox1DragDrop(Sender, Source: TObject; X, Y: Integer);
var
  DropPosition, StartPosition: Integer;
  DropPoint: TPoint;

begin
  DropPoint.X := X;
  DropPoint.Y := Y;
  with Source as TColumnListBox do
  begin
    DropPosition := ItemAtPos(DropPoint,True) ;
    listbox1.Items.Add('Drag & drop from ' + inttostr(itemindex)+' to '+inttostr(dropposition));

    startposition := itemindex;
    if dropposition > itemindex then
      inc(dropposition)
    else
      startposition := itemindex + 1;

    beginupdate;
    listboxitems.Insert(dropposition).Assign(listboxitems[itemindex]);
    listboxitems.Delete(startposition);
    endupdate;
  end;
end;

procedure TForm1.ColumnListBox1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
   Accept := true;
end;

end.
